/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantMethodHandle
extends Constant {
    private int reference_kind;
    private int reference_index;

    public ConstantMethodHandle(ConstantMethodHandle constantMethodHandle) {
        this(constantMethodHandle.getReferenceKind(), constantMethodHandle.getReferenceIndex());
    }

    ConstantMethodHandle(DataInput dataInput) throws IOException {
        this(dataInput.readUnsignedByte(), dataInput.readUnsignedShort());
    }

    public ConstantMethodHandle(int n, int n2) {
        super((byte)15);
        this.reference_kind = n;
        this.reference_index = n2;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitConstantMethodHandle(this);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(super.getTag());
        dataOutputStream.writeByte(this.reference_kind);
        dataOutputStream.writeShort(this.reference_index);
    }

    public int getReferenceKind() {
        return this.reference_kind;
    }

    public void setReferenceKind(int n) {
        this.reference_kind = n;
    }

    public int getReferenceIndex() {
        return this.reference_index;
    }

    public void setReferenceIndex(int n) {
        this.reference_index = n;
    }

    @Override
    public String toString() {
        return super.toString() + "(reference_kind = " + this.reference_kind + ", reference_index = " + this.reference_index + ")";
    }
}

