/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ModuleMainClass
extends Attribute {
    private int main_class_index;

    public ModuleMainClass(ModuleMainClass moduleMainClass) {
        this(moduleMainClass.getNameIndex(), moduleMainClass.getLength(), moduleMainClass.getHostClassIndex(), moduleMainClass.getConstantPool());
    }

    public ModuleMainClass(int n, int n2, int n3, ConstantPool constantPool) {
        super((byte)26, n, n2, constantPool);
        this.main_class_index = n3;
    }

    ModuleMainClass(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, 0, constantPool);
        this.main_class_index = dataInput.readUnsignedShort();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitModuleMainClass(this);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.main_class_index);
    }

    public int getHostClassIndex() {
        return this.main_class_index;
    }

    public void setHostClassIndex(int n) {
        this.main_class_index = n;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ModuleMainClass: ");
        String string = super.getConstantPool().getConstantString(this.main_class_index, (byte)7);
        stringBuilder.append(Utility.compactClassName(string, false));
        return stringBuilder.toString();
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        ModuleMainClass moduleMainClass = (ModuleMainClass)this.clone();
        moduleMainClass.setConstantPool(constantPool);
        return moduleMainClass;
    }
}

