/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.util;

import com.sun.org.apache.xerces.internal.util.FeatureState;
import com.sun.org.apache.xerces.internal.util.PropertyState;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponentManager;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParserConfigurationSettings
implements XMLComponentManager {
    protected static final String PARSER_SETTINGS = "http://apache.org/xml/features/internal/parser-settings";
    protected List<String> fRecognizedProperties;
    protected Map<String, Object> fProperties;
    protected List<String> fRecognizedFeatures = new ArrayList<String>();
    protected Map<String, Boolean> fFeatures;
    protected XMLComponentManager fParentSettings;

    public ParserConfigurationSettings() {
        this(null);
    }

    public ParserConfigurationSettings(XMLComponentManager xMLComponentManager) {
        this.fRecognizedProperties = new ArrayList<String>();
        this.fFeatures = new HashMap<String, Boolean>();
        this.fProperties = new HashMap<String, Object>();
        this.fParentSettings = xMLComponentManager;
    }

    public void addRecognizedFeatures(String[] stringArray) {
        int n = stringArray != null ? stringArray.length : 0;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (this.fRecognizedFeatures.contains(string)) continue;
            this.fRecognizedFeatures.add(string);
        }
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
        FeatureState featureState = this.checkFeature(string);
        if (featureState.isExceptional()) {
            throw new XMLConfigurationException(featureState.status, string);
        }
        this.fFeatures.put(string, bl);
    }

    public void addRecognizedProperties(String[] stringArray) {
        this.fRecognizedProperties.addAll(Arrays.asList(stringArray));
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
        PropertyState propertyState = this.checkProperty(string);
        if (propertyState.isExceptional()) {
            throw new XMLConfigurationException(propertyState.status, string);
        }
        this.fProperties.put(string, object);
    }

    @Override
    public boolean getFeature(String string) throws XMLConfigurationException {
        FeatureState featureState = this.getFeatureState(string);
        if (featureState.isExceptional()) {
            throw new XMLConfigurationException(featureState.status, string);
        }
        return featureState.state;
    }

    @Override
    public final boolean getFeature(String string, boolean bl) {
        FeatureState featureState = this.getFeatureState(string);
        if (featureState.isExceptional()) {
            return bl;
        }
        return featureState.state;
    }

    @Override
    public FeatureState getFeatureState(String string) {
        Boolean bl = this.fFeatures.get(string);
        if (bl == null) {
            FeatureState featureState = this.checkFeature(string);
            if (featureState.isExceptional()) {
                return featureState;
            }
            return FeatureState.is(false);
        }
        return FeatureState.is(bl);
    }

    @Override
    public final Object getProperty(String string) throws XMLConfigurationException {
        PropertyState propertyState = this.getPropertyState(string);
        if (propertyState.isExceptional()) {
            throw new XMLConfigurationException(propertyState.status, string);
        }
        return propertyState.state;
    }

    @Override
    public Object getProperty(String string, Object object) {
        PropertyState propertyState = this.getPropertyState(string);
        if (propertyState.isExceptional()) {
            return object;
        }
        return propertyState.state;
    }

    @Override
    public PropertyState getPropertyState(String string) {
        PropertyState propertyState;
        Object object = this.fProperties.get(string);
        if (object == null && (propertyState = this.checkProperty(string)).isExceptional()) {
            return propertyState;
        }
        return PropertyState.is(object);
    }

    protected FeatureState checkFeature(String string) throws XMLConfigurationException {
        if (!this.fRecognizedFeatures.contains(string)) {
            if (this.fParentSettings != null) {
                return this.fParentSettings.getFeatureState(string);
            }
            return FeatureState.NOT_RECOGNIZED;
        }
        return FeatureState.RECOGNIZED;
    }

    protected PropertyState checkProperty(String string) throws XMLConfigurationException {
        if (!this.fRecognizedProperties.contains(string)) {
            if (this.fParentSettings != null) {
                PropertyState propertyState = this.fParentSettings.getPropertyState(string);
                if (propertyState.isExceptional()) {
                    return propertyState;
                }
            } else {
                return PropertyState.NOT_RECOGNIZED;
            }
        }
        return PropertyState.RECOGNIZED;
    }
}

